% ALPHA ELECTRIC MOTOR DEFINITION
% Generated 06-Apr-2023 16:27:35

% SUGGESTED CITATION:
% Generic IPM 150kW EDU - ALPHA Map Package. Version 2023-04. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
mg = class_REVS_emachine_geared();
mg.name =  'Generic IPM 150kW EDU'; 
mg.source_filename = mfilename;

% Physical Description
mg.electrical_source =  'propulsion'; 
mg.inertia_kgm2 =  0.0075802837500000006; 
mg.type = enum_emachine_type.EDU;
mg.gear.ratio =  9.5; 
mg.gear.efficiency_norm =  1; 

% Capacity Limits
mg.max_speed_radps =  1570.7963267948965; 
mg.max_torque_Nm =  312; 
mg.max_motor_power_W =  150000; 
mg.max_generator_power_W =  150000; 
mg.positive_torque_limit_Nm = class_REVS_dynamic_lookup;
mg.positive_torque_limit_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.positive_torque_limit_Nm.axis_1.breakpoints = [	     0.0000000000000000	    104.71975511965977	    209.43951023931953	    314.15926535897933	    418.87902047863906	    523.59877559829886	    628.31853071795865	    733.03828583761833	    837.75804095727813	    942.47779607693792	    1047.1975511965977	    1151.9173063162575	    1256.6370614359173	    1361.3568165555769	    1466.0765716752367	    1570.7963267948965		]; 
mg.positive_torque_limit_Nm.axis_2.signal =  'voltage_V'; 
mg.positive_torque_limit_Nm.axis_2.breakpoints =  350; 
mg.positive_torque_limit_Nm.table = [	     311.88000000000000	    311.88000000000000	    311.89999999999998	    311.89999999999998	    311.89999999999998	    279.97000000000003	    227.88000000000000	    190.68000000000001	    162.77000000000001	    141.06999999999999	    123.70999999999999	    109.50000000000000	    97.659999999999997	    87.650000000000006	    79.060000000000002	    71.620000000000005		]; 
mg.negative_torque_limit_Nm = class_REVS_dynamic_lookup;
mg.negative_torque_limit_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.negative_torque_limit_Nm.axis_1.breakpoints = [	     0.0000000000000000	    104.71975511965977	    209.43951023931953	    314.15926535897933	    418.87902047863906	    523.59877559829886	    628.31853071795865	    733.03828583761833	    837.75804095727813	    942.47779607693792	    1047.1975511965977	    1151.9173063162575	    1256.6370614359173	    1361.3568165555769	    1466.0765716752367	    1570.7963267948965		]; 
mg.negative_torque_limit_Nm.axis_2.signal =  'voltage_V'; 
mg.negative_torque_limit_Nm.axis_2.breakpoints =  350; 
mg.negative_torque_limit_Nm.table = [	    -311.88000000000000	   -311.88000000000000	   -311.89999999999998	   -311.89999999999998	   -311.89999999999998	   -279.97000000000003	   -227.88000000000000	   -190.68000000000001	   -162.77000000000001	   -141.06999999999999	   -123.70999999999999	   -109.50000000000000	   -97.659999999999997	   -87.650000000000006	   -79.060000000000002	   -71.620000000000005		]; 

% Losses & Efficiency
mg.electric_power_W = class_REVS_dynamic_lookup;
mg.electric_power_W.axis_1.signal =  'emach_spd_radps'; 
mg.electric_power_W.axis_1.breakpoints = [	     0.0000000000000000	    104.71975511965972	    209.43951023931945	    314.15926535897938	    418.87902047863889	    523.59877559829886	    628.31853071795877	    733.03828583761810	    837.75804095727801	    942.47779607693815	    1047.1975511965977	    1151.9173063162575	    1256.6370614359175	    1361.3568165555769	    1466.0765716752364	    1570.7963267948967		]; 
mg.electric_power_W.axis_2.signal =  'emach_trq_Nm'; 
mg.electric_power_W.axis_2.breakpoints = [	    -311.88118811881191	   -259.90099009900990	   -222.77227722772278	   -185.64356435643560	   -148.51485148514851	   -111.38613861386139	   -66.757425742574256	   -46.351006068348774	   -29.702970297029701	    0.0000000000000000	    29.702970297029712	    46.351006068348767	    66.757425742574256	    111.38613861386139	    148.51485148514851	    185.64356435643560	    222.77227722772278	    259.90099009900990	    311.88118811881191		]; 
mg.electric_power_W.table = [
    10011.292391662248	    7295.3977212824284	    4991.8914938964199	    3626.1058633956582	    2521.9897047176073	    1616.2883812044786	    792.10058544321760	    516.72654722041807	    325.71137250736064	    134.24061525644436	    308.27126770141228	    491.50637763044813	    754.57278789106465	    1539.3523429958125	    2401.8945502117003	    3453.4336872709619	    4754.1823536903439	    6947.9978360553678	    9534.5641803261005	;
   -21570.703930523829	   -19025.815133239204	   -17563.797231294273	   -15161.363562680548	   -12492.288770988727	   -9617.2632682690910	   -5886.9857418998336	   -4087.7466373058301	   -2589.7565980986851	    257.12881322907339	    3602.8543462313319	    5582.3516696129382	    8042.4416322047000	    13613.971319562772	    18466.866857240453	    23515.962058817266	    28819.002171146152	    35017.675580433672	    43221.471842478437	;
   -52528.876432811907	   -44991.581015515061	   -39919.183318350697	   -33864.386456168257	   -27506.898326561448	   -20906.826530990445	   -12643.920785836854	   -8759.2121372835900	   -5554.8829425049034	    361.06403658042331	    6850.4124119947237	    10609.478317833127	    15256.143245112722	    25635.242139920789	    34531.523912441880	    43658.915754960515	    53074.586414546895	    63425.874230642548	    77502.497655395928	;
   -84256.848106758101	   -71412.697854706930	   -62558.621599789745	   -52715.340432607321	   -42581.444656612519	   -32201.764307278176	   -19378.548321038714	   -13404.643544682267	   -8494.8899317692903	    483.36325081706843	    10121.659132333234	    15661.322438844751	    22491.111702600345	    37651.397798543519	    50539.098285075168	    63660.982682911359	    77059.644829046345	    91400.405143949683	    111050.38300105945	;
   -115123.55180107633	   -97634.393132078723	   -85212.798442445302	   -71701.791348503597	   -57807.836969077543	   -43584.737032856079	   -26098.825237650737	   -18023.312174160128	   -11409.448149661075	    628.84700729730298	    13416.839625780824	    20738.551885541689	    29739.776739060082	    49583.715727726078	    66402.057442220583	    83534.004951563285	    101030.66579795236	    119564.85879951520	    145418.49541578465	;
   -144748.01000886509	   -122497.32493261431	   -106553.63092051187	   -89854.923524799044	   -72521.374191751820	   -54760.507424776522	   -32905.103824904865	   -22720.035970491932	   -14351.204644507454	    811.99289157132557	    16685.743503242767	    25741.309411736795	    36906.564539231287	    61713.374166754598	    82753.450153856640	    104200.66211578669	    126252.47802062919	    149023.35175510950	    180969.34374467572	;
   -173533.57622511734	   -145719.47110374039	   -125859.57095122336	   -107103.73900340725	   -86836.233612568147	   -65619.173661337933	   -39458.592309471867	   -27271.889745296019	   -17262.981195183838	    893.90575568595261	    19984.282708610608	    30882.421334340943	    44314.014318562491	    74145.021406349697	    99484.533483354884	    125728.55158751615	    153412.32217076517	    180045.22816951264	    217322.10022761222	;
   -201922.90097444615	   -169087.93804352716	   -145918.13337868746	   -123150.79019559927	   -100505.68698961967	   -76268.198314298643	   -45863.015399844233	   -31688.807059344279	   -20054.922624304290	    1073.5062523950814	    23395.710200438178	    36151.634204400565	    51863.546219561933	    86776.342752305936	    116830.26755678670	    148401.06284403504	    179857.14575416106	    210931.36517727023	    254058.71277817781	;
   -230352.92313150468	   -192666.26741509361	   -165978.07021655235	   -139538.20540337224	   -113325.74107918788	   -86526.152240544805	   -52160.642050340139	   -36006.810368954175	   -22728.333796351395	    1393.6522422946814	    26918.280008059934	    41514.460493219092	    59514.949770547064	    99780.111528118170	    134984.96773925435	    170751.30173920604	    206304.48245901745	    241623.89073302734	    290766.25637177011	;
   -259039.11786412715	   -216416.23284473040	   -186052.29918475545	   -155725.98844049778	   -125468.68555980548	   -95945.360843426795	   -58249.205680655374	   -40246.119010831302	   -25361.584422025157	    1789.8718194876174	    30478.159920552705	    46951.908243761332	    67365.547434544307	    113582.67202674737	    153784.74252482154	    193294.83600838215	    232744.53955908865	    272161.95560618443	    327241.74214001244	;
   -288016.78410082555	   -240341.27511702161	   -206325.18382843689	   -172422.87723871414	   -138804.32626663736	   -105445.46800373036	   -64144.926535458442	   -44296.068941136575	   -27819.893873096593	    2297.8752295779518	    34203.179474381664	    52569.208779249886	    75399.901278275996	    127308.30166977213	    171453.40656257223	    215360.78105941004	    259005.13998386884	    302544.71755304874	    363452.11391552648	;
   -317258.01133365475	   -264537.33727778908	   -226902.41004490576	   -189340.65091075774	   -151937.82808737337	   -114719.97429476233	   -69850.086854120236	   -48198.777982491709	   -30173.069468732578	    2856.6102726123536	    38027.638345243853	    58326.489939231411	    83615.620916969157	    141248.44918218831	    189320.17469232396	    237227.84708417710	    284989.16011936922	    332682.18719556229	    399422.62892526051	;
   -346705.35145825875	   -288992.21017770731	   -247759.90099168461	   -206496.40455305335	   -165144.48124136974	   -123765.22422804369	   -75336.054553989859	   -51939.234702716989	   -32417.980544575930	    3448.8551582999985	    41954.574312649747	    64238.181128199380	    92040.832464679042	    155409.89985972072	    207133.72644489526	    258885.97295593540	    310721.05976031045	    362585.00899684528	    435205.31175029598	;
   -376283.64093633619	   -313621.07028902683	   -268828.95169656735	   -224001.22821519614	   -179176.33038896474	   -134468.38305802390	   -80732.000124082551	   -55458.036032035037	   -34509.214408360218	    4400.1768301117927	    46022.298939780798	    70361.285761744555	    100572.94419357025	    168055.22200649203	    224195.43388569404	    280230.08902167785	    336263.95580525650	    392331.40861916693	    470868.79867144395	;
   -405924.45741972065	   -338371.98897344153	   -290091.28875869705	   -241780.01300787632	   -193425.24847079115	   -144941.33444228017	   -86093.684542145595	   -58888.654963007284	   -36475.301680271987	    5253.0303199366363	    50210.752831771599	    76567.499658887900	    109126.73206509826	    180909.30400828051	    241058.45535585828	    301325.69233975816	    361633.03640308097	    421968.61179055856	    506475.71944387432	;
   -435585.24450128898	   -363186.98431615211	   -311448.35490758531	   -259638.54360143043	   -207643.93479956902	   -155300.23300574950	   -91663.057090251154	   -62319.922918383571	   -38303.634299466881	    6212.3237340578780	    54529.333806195995	    82769.317879924012	    117472.63232206760	    193858.28472535699	    257946.88097770576	    322349.04630306654	    386916.89881408704	    451548.47239452519	    542064.75531257875	]; 
mg.unpowered_torque_loss_Nm = class_REVS_dynamic_lookup;
mg.unpowered_torque_loss_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.unpowered_torque_loss_Nm.axis_1.breakpoints = [	    -15000.000000000000	    15000.000000000000		]; 
mg.unpowered_torque_loss_Nm.table = [	     0.0000000000000000	    0.0000000000000000		]; 
